<?php
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Hash;
use Session;
use App\Models\User;
use App\Models\Reseller;
use Illuminate\Support\Facades\Auth;
class CustomAuthController extends Controller
{
    public function index()
    {
        return view('auth.login');
    }

    public function customLogin(Request $request)
    {
        $request->validate([
            'email' => 'required',
            'password' => 'required',
        ]);

        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) {
            return redirect()->route('home')
                        ->withSuccess('Signed in');
        }

        return back()->withErrors('Login details are not valid');
    }

    public function register()
    {
        return view('auth.registration');
    }

    public function registration(Request $request)
    {
        $request->validate([
            'username' => 'required',
            'brand_name' => 'required|string',
            'email' => 'required|email|unique:users',
            'password' => 'required|min:6|confirmed',
        ]);

        $data = $request->all();
        $check = $this->create($data);

        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) {
            return redirect()->route('home')
                ->withSuccess('You have signed-up');
        }
    }

    public function create(array $data)
    {
        $user = new User();
        $user->username = $data['username'];
        $user->email = $data['email'];
        $user->role = "user";
        $user->password = Hash::make($data['password']);
        if($user->save()){
            $reseller = new Reseller();
            $reseller->name = $data['brand_name'];
            $reseller->token = null;
            $reseller->domain = "cpanelseller.com";
            $reseller->balance = 0;
            $reseller->end_at = "2099-12-31";
            $reseller->main_domain = "cpanelseller.com";
            $reseller->folder = "files";
            $reseller->level_id = 9;
            $reseller->status = 1;
            $reseller->key_cmd = "CPS";
            $reseller->type = "local";
            $reseller->client_id = $user->id;
            $reseller->user_id = $user->id;
            $reseller->trial_perm = 0;
            $reseller->save();
            return 1;
        }
    }
//
//    public function home()
//    {
//        if(Auth::check()){
//            return view('home');
//        }
//
//        return redirect("login")->withSuccess('You are not allowed to access');
//    }

    public function signOut() {
        Session::flush();
        Auth::logout();

        return Redirect('login');
    }
}
